'From OLPC2.0 of ''24 October 2006'' [latest update: #1229] on 10 March 2007 at 11:04:03 pm'!
"Change Set:		OggCodec
Date:			10 March 2007
Author:			Takashi Yamamiya

Ogg vorbis / speex codec module.
Try:
OggDriver example.
"
!

SoundCodec subclass: #OggDriver
	instanceVariableNames: 'state rate channels quality headerSound'
	classVariableNames: 'SpeexDefaultQuality SqOggDecode SqOggEncode SqOggError SqOggInitialized SqOggNeedMore SqOggRunning SqOggSuccess SqSpeex SqSpeexGotInfo SqVorbis SqVorbisGotComment SqVorbisGotInfo'
	poolDictionaries: ''
	category: 'Sound-Ogg'!

!OggDriver commentStamp: 'tak 3/9/2007 19:00' prior: 0!
OggDriver is a codec with Ogg container.
The subclass of OggDriver has responsible for actual internal codec.

Structure:
 state		ByteArray -- holds internal state of the plugin.
 rate		SmallInteger -- sample rate
 channels	SmallInteger -- stereo = 2 or mono = 1
 quality		Float -- codec dependent quality value.
 headerSound OggSoundData -- It keeps the header chunk to remember meta data.

http://www.xiph.org/
!

CompressedSoundData subclass: #OggSoundData
	instanceVariableNames: 'decoder header'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Sound-Ogg'!

!OggSoundData commentStamp: 'tak 3/9/2007 18:56' prior: 0!
Because vorbis and speex requires statefull encoding, we can't use CompressedSoundData as is. CompressedSoundData only remembers its codec class, so it doesn't help to reproduce the original context. OggSoundData remembers its header chunk to keep correspond decoder.

Structure:
 decoder			SoundCodec -- decoder instance (only on header sound)
 header			OggSound -- an OggSound including decoder

!

OggDriver subclass: #OggSpeexCodec
	instanceVariableNames: 'driver'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Sound-Ogg'!
OggDriver subclass: #OggVorbisCodec
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Sound-Ogg'!

!CompressedSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 11:27'!
codecSignature
	^ self className , ' codecName: ' , codecName printString, ' samplingRate: ' , samplingRate printString! !

!CompressedSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 11:28'!
source: aByteArray
	channels := {aByteArray}.
! !


!CompressedSoundData class methodsFor: 'instance creation' stamp: 'tak 3/10/2007 18:25'!
codecName: codecName samplingRate: samplingRate 
	| instance |
	"OggSoundData builds compressed data from here."
	instance := self new.
	instance codecName: codecName.
	instance samplingRate: samplingRate.
	instance soundClassName: #SampledSound.
	instance gain: 1.0.
	^ instance! !


!OggDriver methodsFor: 'accessing' stamp: 'tak 2/22/2007 21:33'!
channels
	^ channels! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 3/9/2007 18:39'!
channels: aNumber
	^ channels := aNumber! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 2/22/2007 21:33'!
hasHeader
	^ rate notNil! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 3/9/2007 18:40'!
quality
	^ quality! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 3/9/2007 18:40'!
quality: aFloat
	^ quality := aFloat asFloat! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 2/22/2007 21:33'!
rate
	^ rate! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 3/9/2007 18:38'!
rate: aNumber
	^ aNumber! !

!OggDriver methodsFor: 'accessing' stamp: 'tak 2/22/2007 21:33'!
soundFromCompressedData: aByteArray 
	| soundBuffer sound monoCount left right |
	soundBuffer := self decodeCompressedData: aByteArray.
	soundBuffer
		ifNil: [^ nil].
	self channels == 1
		ifTrue: [^ SampledSound samples: soundBuffer samplingRate: self rate].
	self channels == 2
		ifTrue: [sound := MixedSound new.
			monoCount := soundBuffer monoSampleCount // 2.
			left := SoundBuffer newMonoSampleCount: monoCount.
			self
				primitiveExtractMono: left
				src: soundBuffer
				size: monoCount
				channel: 0.
			right := SoundBuffer newMonoSampleCount: monoCount.
			self
				primitiveExtractMono: right
				src: soundBuffer
				size: monoCount
				channel: 1.
			sound
				add: (SampledSound samples: left samplingRate: self rate)
				pan: 0.
			sound
				add: (SampledSound samples: right samplingRate: self rate)
				pan: 1.
			^ sound].
	^ nil! !

!OggDriver methodsFor: 'compress/decompress' stamp: 'tak 3/6/2007 15:01'!
compressSound: aSound 
	| buffer decoded |
	rate := aSound originalSamplingRate asInteger.
	buffer := self encodeSoundBuffer: aSound samples.
	decoded := OggSoundData source: buffer codecName: self class name.
	headerSound
		ifNil: [headerSound := decoded]
		ifNotNil: [decoded header: headerSound].
	^ decoded! !

!OggDriver methodsFor: 'compress/decompress' stamp: 'tak 3/5/2007 17:23'!
decodeCompressedData: aByteArray 
	"Answer decompressed SoundBuffer, or nil if it needs more data"
	| decoded size result |
	state
		ifNil: [state := self startDecoder].
	result := self
				primitiveWrite: state
				buffer: aByteArray
				size: aByteArray size.
	result = SqOggSuccess
		ifFalse: [self error: 'Compressed data is corrupt'].
	size := self primitiveReadSize: state.
	size = 0
		ifTrue: [^ nil].
	decoded := SoundBuffer newMonoSampleCount: size // 2.
	self
		primitiveRead: state
		buffer: decoded
		size: size.
	self hasHeader
		ifFalse: [self headerComplete].
	^ decoded! !

!OggDriver methodsFor: 'compress/decompress' stamp: 'tak 3/5/2007 17:23'!
encodeSoundBuffer: samples 
	| size encoded |
	state
		ifNil: [state := self startEncoder].
	self
		primitiveWrite: state
		buffer: samples
		size: samples monoSampleCount * 2.
	self primitivePacketFlush: state.
	size := self primitiveReadSize: state.
	encoded := ByteArray new: size.
	self
		primitiveRead: state
		buffer: encoded
		size: size.
	^ encoded! !

!OggDriver methodsFor: 'compress/decompress' stamp: 'tak 2/23/2007 01:28'!
headerComplete
	rate := self primitiveGetRate: state.
	channels := self primitiveGetChannels: state! !

!OggDriver methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:12'!
release
	state
		ifNotNil: [self primitiveClose: state.
			state := nil].
	rate := nil.
	channels := nil.
	quality := nil.
	headerSound := nil! !

!OggDriver methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:12'!
reset
	self release! !

!OggDriver methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:17'!
startDecoder
	self shouldBeImplemented! !

!OggDriver methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:17'!
startEncoder
	self shouldBeImplemented! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 3/10/2007 18:17'!
primitiveClose: ogg
	<primitive: 'primitiveClose' module: 'OggPlugin'>! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveExtractMono: dest src: src size: size channel: channel
	<primitive: 'primitiveExtractMono' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveGetChannels: ogg
	<primitive: 'primitiveGetChannels' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveGetCommentSize: ogg
	<primitive: 'primitiveGetCommentSize' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveGetComment: ogg buffer: buffer size: size
	<primitive: 'primitiveGetComment' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveGetRate: ogg
	<primitive: 'primitiveGetRate' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/25/2007 20:08'!
primitiveGetState: ogg
	<primitive: 'primitiveGetState' module: 'OggPlugin'>
	^ SqOggInitialized! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveGetVendor: ogg buffer: buffer size: size
	<primitive: 'primitiveGetVendor' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveOpen: mode
	<primitive: 'primitiveOpen' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitivePacketFlush: ogg
	<primitive: 'primitivePacketFlush' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveReadSize: ogg
	<primitive: 'primitiveReadSize' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveRead: ogg buffer: buffer size: size
	<primitive: 'primitiveRead' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveSetChannels: ogg with: value
	<primitive: 'primitiveSetChannels' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveSetQuality: ogg with: value
	<primitive: 'primitiveSetQuality' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveSetRate: ogg with: value
	<primitive: 'primitiveSetRate' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 3/10/2007 18:22'!
primitiveVersion
	"self new primitiveVersion"
	<primitive: 'primitiveVersion' module: 'OggPlugin'>
	^ 0! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveWriteEOS: ogg
	<primitive: 'primitiveWriteEOS' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'primitives' stamp: 'tak 2/22/2007 21:33'!
primitiveWrite: ogg buffer: buffer size: size
	<primitive: 'primitiveWrite' module: 'OggPlugin'>
	self primitiveFailed! !

!OggDriver methodsFor: 'subclass responsibilities' stamp: 'tak 3/5/2007 17:11'!
samplesPerFrame
	^1! !


!OggSoundData methodsFor: 'asSound' stamp: 'tak 3/10/2007 18:20'!
asSound
	| codecClass theDecoder |
	self isHeader
		ifTrue: [codecClass := Smalltalk
						at: codecName
						ifAbsent: [^ self error: 'The codec for decompressing this sound is not available'].
			codecClass isAvailable
				ifFalse: [^ self error: 'The codec for decompressing this sound is not available'].
			decoder
				ifNotNil: [decoder release].
			theDecoder := decoder := codecClass new]
		ifFalse: [theDecoder := header decoder].
	^ theDecoder soundFromCompressedData: channels first! !

!OggSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 11:19'!
codecName: aSymbol
	codecName := aSymbol.! !

!OggSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 11:55'!
codecSignature
	^ self className , ' codecName: ', codecName printString! !

!OggSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 10:34'!
decoder
	self isHeader
		ifTrue: [^ decoder].
	self error: 'Only header has a decoder.'! !

!OggSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 10:36'!
header: anOggSoundData
	header := anOggSoundData! !

!OggSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 10:34'!
isHeader
	^ header isNil! !

!OggSoundData methodsFor: 'accessing' stamp: 'tak 3/6/2007 10:38'!
printOn: aStream 
	super printOn: aStream.
	self isHeader
		ifTrue: [aStream nextPutAll: '[header]']! !


!OggSoundData class methodsFor: 'instance creation' stamp: 'tak 3/6/2007 11:20'!
codecName: aSymbol
	^ self new codecName: aSymbol.! !

!OggSoundData class methodsFor: 'instance creation' stamp: 'tak 3/6/2007 11:21'!
source: aByteArray codecName: aSymbol 
	| instance |
	instance := self new.
	instance source: aByteArray.
	instance codecName: aSymbol.
	^ instance! !

!OggSoundData class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:54'!
example1
	"OggSoundData example1"
	| source codec sound |
	source := FMSound majorChord asSampledSound.
	sound := SequentialSound new.
	codec := OggVorbisCodec new.
	sound add: (codec compressSound: source).
	sound add: (codec compressSound: source).
	sound add: (codec compressSound: source).
	sound play! !


!OggSpeexCodec methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:21'!
startDecoder
	^ self
		primitiveOpen: (SqSpeex bitOr: SqOggDecode)! !

!OggSpeexCodec methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:22'!
startEncoder
	| s |
	s := self
				primitiveOpen: (SqSpeex bitOr: SqOggEncode).
	"now only support 1 channel"
	channels := 1.
	rate := rate
				ifNil: [11025].
	quality := quality
				ifNil: [SpeexDefaultQuality].
	self primitiveSetChannels: s with: channels.
	self primitiveSetRate: s with: rate.
	self primitiveSetQuality: s with: quality.
	^ s! !


!OggVorbisCodec methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:22'!
startDecoder
	^ self
		primitiveOpen: (SqVorbis bitOr: SqOggDecode)! !

!OggVorbisCodec methodsFor: 'initialize-release' stamp: 'tak 3/5/2007 17:23'!
startEncoder
	| s |
	s := self
				primitiveOpen: (SqVorbis bitOr: SqOggEncode).
	channels := channels
				ifNil: [1].
	rate := rate
				ifNil: [11025].
	quality := quality
				ifNil: [0.0].
	self primitiveSetChannels: s with: channels.
	self primitiveSetRate: s with: rate.
	self primitiveSetQuality: s with: quality.
	^ s! !


!SoundCodec class methodsFor: 'accessing' stamp: 'tak 3/10/2007 18:13'!
isAvailable
	^ true! !


!OggDriver class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:53'!
example
	"OggDriver example"
	self example1. "Primitive test: Writing Ogg Vorbis."
	self example2. "Primitive test: Reading Ogg Vorbis."
	self example3. "Primitive metatada test: Reading Ogg Vorbis and output to Transcript."
	(Delay forSeconds: 1) wait.
	self example4. "Primitive test: Writing Ogg Speex."
	self example5. "Primitive test: Reading Ogg Speex."
	(Delay forSeconds: 1) wait.
	self example6. "OggVorbisCodec test: Encode and decode with Vorbis."
	(Delay forSeconds: 1) wait.
	self example7. "OggSpeexCodec test: Encode and decode with Speex"
	(Delay forSeconds: 1) wait.
	self example8. "OggSound test: Encode and decode with Vorbis."
	(Delay forSeconds: 1) wait.
	self example9. "OggSound test: Encode and decode with Speex."
! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:28'!
example1
	"OggDriver example1"
	"Primitive test: Writing Ogg Vorbis."
	| driver ogg source size compressed f fileName |
	fileName := 'majorChord.ogg'.
	source := FMSound majorChord asSampledSound.
	driver := self new.
	ogg := driver
				primitiveOpen: (SqVorbis bitOr: SqOggEncode).
	driver primitiveSetChannels: ogg with: 1.
	driver primitiveSetRate: ogg with: 22050.
	driver primitiveSetQuality: ogg with: -0.1.
	driver
		primitiveWrite: ogg
		buffer: source samples
		size: source samples monoSampleCount * 2.
	driver primitiveWriteEOS: ogg.
	size := driver primitiveReadSize: ogg.
	compressed := ByteArray new: size.
	driver
		primitiveRead: ogg
		buffer: compressed
		size: size.
	driver primitiveClose: ogg.
	f := FileDirectory default forceNewFileNamed: fileName.
	[f binary.
	f nextPutAll: compressed]
		ensure: [f close]! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:29'!
example2
	"OggDriver example2"
	"Primitive test: Reading Ogg Vorbis."
	| f compressed driver ogg decoded size fileName rate |
	fileName := 'majorChord.ogg'.
	f := FileDirectory default readOnlyFileNamed: fileName.
	[f binary.
	compressed := f contents]
		ensure: [f close].
	driver := self new.
	ogg := driver
				primitiveOpen: (SqVorbis bitOr: SqOggDecode).
	driver
		primitiveWrite: ogg
		buffer: compressed
		size: compressed size.
	rate := driver primitiveGetRate: ogg.
	size := driver primitiveReadSize: ogg.
	decoded := SoundBuffer newMonoSampleCount: size // 2.
	driver
		primitiveRead: ogg
		buffer: decoded
		size: size.
	driver primitiveClose: ogg.
	(SampledSound samples: decoded samplingRate: rate) play! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:30'!
example3
	"OggDriver example3"
	"Primitive metatada test: Reading Ogg Vorbis and output to Transcript."
	| f compressed driver ogg vendor comment commentSize fileName rate channels |
	fileName := 'majorChord.ogg'.
	f := FileDirectory default readOnlyFileNamed: fileName.
	[f binary.
	compressed := f contents]
		ensure: [f close].
	driver := self new.
	ogg := driver
				primitiveOpen: (SqVorbis bitOr: SqOggDecode).
	driver
		primitiveWrite: ogg
		buffer: compressed
		size: compressed size.
	self assert: (driver primitiveGetState: ogg)
			== SqOggRunning.
	rate := driver primitiveGetRate: ogg.
	channels := driver primitiveGetChannels: ogg.
	Transcript cr;
		show: ('Bitstream is {1} channel, {2} Hz' format: {rate. channels}).
	vendor := String new: 1024.
	driver
		primitiveGetVendor: ogg
		buffer: vendor
		size: 1024.
	Transcript cr; show: 'Encoded by:'
			, (vendor readStream
					upTo: (Character value: 0)).
	commentSize := driver primitiveGetCommentSize: ogg.
	comment := String new: commentSize.
	driver
		primitiveGetComment: ogg
		buffer: comment
		size: commentSize.
	Transcript cr; show: comment.
	driver primitiveClose: ogg! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:34'!
example4
	"OggDriver example4"
	"Primitive test: Writing Ogg Speex."
	| driver ogg source size compressed f fileName |
	fileName := 'majorChord.spx'.
	source := FMSound majorChord asSampledSound.
	driver := self new.
	ogg := driver
				primitiveOpen: (SqSpeex bitOr: SqOggEncode).
	driver primitiveSetChannels: ogg with: 1.
	driver primitiveSetRate: ogg with: 22050.
	driver primitiveSetQuality: ogg with: 4.0.
	driver
		primitiveWrite: ogg
		buffer: source samples
		size: source samples monoSampleCount * 2.
	driver primitiveWriteEOS: ogg.
	size := driver primitiveReadSize: ogg.
	compressed := ByteArray new: size.
	driver
		primitiveRead: ogg
		buffer: compressed
		size: size.
	driver primitiveClose: ogg.
	f := FileDirectory default forceNewFileNamed: fileName.
	[f binary.
	f nextPutAll: compressed]
		ensure: [f close]! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/9/2007 18:31'!
example5
	"OggDriver example5"
	"Primitive test: Reading Ogg Speex."
	| f compressed driver ogg decoded size fileName rate |
	fileName := 'majorChord.spx'.
	f := FileDirectory default readOnlyFileNamed: fileName.
	[f binary.
	compressed := f contents]
		ensure: [f close].
	driver := self new.
	ogg := driver
				primitiveOpen: (SqSpeex bitOr: SqOggDecode).
	driver
		primitiveWrite: ogg
		buffer: compressed
		size: compressed size.
	rate := driver primitiveGetRate: ogg.
	size := driver primitiveReadSize: ogg.
	decoded := SoundBuffer newMonoSampleCount: size // 2.
	driver
		primitiveRead: ogg
		buffer: decoded
		size: size.
	driver primitiveClose: ogg.
	(SampledSound samples: decoded samplingRate: rate) play! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/10/2007 18:32'!
example6
	"OggDriver example6"
	"OggVorbisCodec test: Encode and decode with Vorbis."
	| src buffer codec encoded decoded |
	src := SampledSound soundNamed: 'chirp'.
	buffer := src samples.
	codec := OggVorbisCodec new.
	encoded := codec encodeSoundBuffer: buffer.
	codec release.
	codec := OggVorbisCodec new.
	decoded := codec decodeCompressedData: encoded.
	codec release.
	(SampledSound samples: decoded samplingRate: src originalSamplingRate) play! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/10/2007 18:32'!
example7
	"OggDriver example7"
	"OggSpeexCodec test: Encode and decode with Speex"
	| src buffer codec encoded decoded |
	src := SampledSound soundNamed: 'chirp'.
	buffer := src samples.
	codec := OggSpeexCodec new.
	encoded := codec encodeSoundBuffer: buffer.
	codec release.
	codec := OggSpeexCodec new.
	decoded := codec decodeCompressedData: encoded.
	codec release.
	(SampledSound samples: decoded samplingRate: src originalSamplingRate) play! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/10/2007 18:33'!
example8
	"OggDriver example8"
	"OggSound test: Encode and decode with Vorbis."
	| src compressed |
	src := SampledSound soundNamed: 'croak'.
	compressed := src compressWith: OggVorbisCodec.
	compressed asSound play! !

!OggDriver class methodsFor: 'examples' stamp: 'tak 3/10/2007 18:33'!
example9
	"OggDriver example9"
	"OggSound test: Encode and decode with Speex."
	| src compressed |
	src := SampledSound soundNamed: 'croak'.
	compressed := src compressWith: OggSpeexCodec.
	compressed asSound play! !

!OggDriver class methodsFor: 'class initialization' stamp: 'tak 3/7/2007 18:48'!
initialize
	"self initialize"
	SqOggSuccess := 0.
	SqOggNeedMore := -1.
	SqOggError := -2.

	SqOggInitialized := 1.
	SqVorbisGotInfo := 2.
	SqSpeexGotInfo := 2.
	SqVorbisGotComment := 3.
	SqOggRunning := 4.

	SqOggEncode := 1.
	SqOggDecode := 2.
	SqVorbis := 4.
	SqSpeex := 8.

	self speexDefaultQuality: 4.0. ! !

!OggDriver class methodsFor: 'class initialization' stamp: 'tak 3/10/2007 17:54'!
playFileNamed: fileName 
	"[self playFileNamed: 'LesVoyages.ogg'] fork"
	| f compressed sound player codec |
	SoundPlayer stopReverb.
	player := QueueSound new.
	player play.
	f := FileDirectory default readOnlyFileNamed: fileName.
	[f binary.
	codec := self new.
	[f atEnd]
		whileFalse: [compressed := f next: 4096.
			sound := codec soundFromCompressedData: compressed.
			sound
				ifNotNil: [player add: sound.
					(Delay forSeconds: sound duration * 0.7) wait]]]
		ensure: [f close.
			codec release]! !

!OggDriver class methodsFor: 'class initialization' stamp: 'tak 3/10/2007 17:56'!
services
	| service |
	service := SimpleServiceEntry
				provider: self
				label: 'sound file'
				selector: #playFileNamed:
				description: 'play the sound'
				buttonLabel: 'play'.
	^ Array with: service! !

!OggDriver class methodsFor: 'accessing' stamp: 'tak 3/10/2007 18:10'!
isAvailable
	"self isAvailable"
	^ self new primitiveVersion > 0! !

!OggDriver class methodsFor: 'accessing' stamp: 'tak 2/25/2007 22:02'!
speexDefaultQuality: aNumber 
	SpeexDefaultQuality := aNumber asFloat! !


!OggSpeexCodec class methodsFor: 'class initialization' stamp: 'tak 3/10/2007 17:57'!
fileReaderServicesForFile: fullName suffix: suffix 
	"self playFileNamed: 'majorChord.spx'"
	^ suffix = 'spx'
		ifTrue: [self services]
		ifFalse: [#()]! !


!OggVorbisCodec class methodsFor: 'class initialization' stamp: 'tak 3/10/2007 17:56'!
fileReaderServicesForFile: fullName suffix: suffix 
	"[self playFileNamed: 'LesVoyages.ogg'] fork"
	^ suffix = 'ogg'
		ifTrue: [self services]
		ifFalse: [#()]! !

OggDriver initialize!
"Postscript:
"
FileList initialize.
!

