'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 10 March 2007 at 6:34:46 pm'!
"Change Set:		OggPlugin
Date:			26 February 2007
Author:			Takashi Yamamiya

Ogg vorbis / speex slang code."!

SmartSyntaxInterpreterPlugin subclass: #OggPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Sound-Ogg'!

!OggPlugin commentStamp: 'tak 3/1/2007 19:34' prior: 0!
This plugin provide an interface to libvorbis sound codec library.

OggPlugin buildSource: '/home/takashi/src/squeak-svn/platforms'.
OggPlugin buildSource: 'c:\takashi\src\3.7.1'!


!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 14:59'!
primitiveGetChannels: oggPtr 
	self primitive: 'primitiveGetChannels' parameters: #(#ByteArray ).
	^ (self cCode: 'SqOggGetChannels((SqOggPtr *) oggPtr)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:00'!
primitiveGetCommentSize: oggPtr 
	self primitive: 'primitiveGetCommentSize' parameters: #(#ByteArray ).
	^ (self cCode: 'SqOggGetCommentSize((SqOggPtr *) oggPtr)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:00'!
primitiveGetComment: oggPtr buffer: buffer size: size 
	self primitive: 'primitiveGetComment' parameters: #(#ByteArray #String #SmallInteger ).
	^ (self cCode: 'SqOggGetComment((SqOggPtr *) oggPtr, buffer, size)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:00'!
primitiveGetRate: oggPtr 
	self primitive: 'primitiveGetRate' parameters: #(#ByteArray ).
	^ (self cCode: 'SqOggGetRate((SqOggPtr *) oggPtr)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:00'!
primitiveGetState: oggPtr 
	self primitive: 'primitiveGetState' parameters: #(#ByteArray ).
	^ (self cCode: 'SqOggGetState((SqOggPtr *) oggPtr)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:00'!
primitiveGetVendor: oggPtr buffer: buffer size: size 
	self primitive: 'primitiveGetVendor' parameters: #(#ByteArray #String #SmallInteger ).
	^ (self cCode: 'SqOggGetVendor((SqOggPtr *) oggPtr, buffer, size)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:01'!
primitiveSetChannels: oggPtr with: value 
	self primitive: 'primitiveSetChannels' parameters: #(#ByteArray #SmallInteger ).
	self cCode: 'SqOggSetChannels((SqOggPtr *) oggPtr, value)'! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:01'!
primitiveSetQuality: oggPtr with: value 
	self primitive: 'primitiveSetQuality' parameters: #(#ByteArray #Float ).
	self cCode: 'SqOggSetQuality((SqOggPtr *) oggPtr, value)'! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/3/2007 15:01'!
primitiveSetRate: oggPtr with: value 
	self primitive: 'primitiveSetRate' parameters: #(#ByteArray #SmallInteger ).
	self cCode: 'SqOggSetRate((SqOggPtr *) oggPtr, value)'! !

!OggPlugin methodsFor: 'accessing' stamp: 'tak 3/10/2007 18:30'!
primitiveVersion
	self primitive: 'primitiveVersion'.
	^ 1 asOop: SmallInteger! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:14'!
primitiveClose: oggPtr
	self primitive: 'primitiveClose' parameters: #(ByteArray).
	self cCode: 'SqOggClose((SqOggPtr *) oggPtr)'! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:11'!
primitiveOpen: mode
	| oggOop oggp |
	self var: #oggp declareC: 'SqOggPtr * oggp'.
	self primitive: 'primitiveOpen' parameters: #(SmallInteger).
	oggOop := interpreterProxy instantiateClass: interpreterProxy classByteArray indexableSize: (self cCode: 'sizeof(SqOggPtr)').
	oggp := self
				cCoerce: (interpreterProxy firstIndexableField: oggOop)
				to: 'SqOggPtr *'.
	self cCode: 'SqOggOpen(mode, oggp)'.
	^ oggOop! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:17'!
primitivePacketFlush: oggPtr
	self primitive: 'primitivePacketFlush' parameters: #(ByteArray).
	self cCode: 'SqOggPacketFlush((SqOggPtr *) oggPtr)'.
! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:57'!
primitiveRead
	| result oggOop oggp size bufferOop buffer |
	self export: true.
	self var: #oggp declareC: 'SqOggPtr * oggp'.
	self var: #buffer declareC: 'char * buffer'.
	interpreterProxy methodArgumentCount = 3
		ifFalse:[^interpreterProxy primitiveFail].
	size := interpreterProxy stackIntegerValue: 0.
	bufferOop := interpreterProxy stackObjectValue: 1.
	buffer := self cCoerce: (interpreterProxy firstIndexableField: bufferOop) to: 'char *'.
	oggOop := interpreterProxy stackObjectValue: 2.
	oggp := self oggInstanceOf: oggOop.
	interpreterProxy success: (interpreterProxy isWordsOrBytes: bufferOop).
	interpreterProxy failed
		ifTrue: [^ nil].
	result := self cCode: 'SqOggRead(oggp, buffer, size)'.
	interpreterProxy pop: 4.
	^ interpreterProxy pushInteger: result
	! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:58'!
primitiveReadSize: oggPtr 
	self primitive: 'primitiveReadSize' parameters: #(#ByteArray ).
	^ (self cCode: 'SqOggReadSize((SqOggPtr *) oggPtr)')
		asOop: SmallInteger! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:58'!
primitiveWrite
	| result oggOop oggp size bufferOop buffer |
	self export: true.
	self var: #oggp declareC: 'SqOggPtr * oggp'.
	self var: #buffer declareC: 'char * buffer'.
	interpreterProxy methodArgumentCount = 3
		ifFalse:[^interpreterProxy primitiveFail].
	size := interpreterProxy stackIntegerValue: 0.
	bufferOop := interpreterProxy stackObjectValue: 1.
	buffer := self cCoerce: (interpreterProxy firstIndexableField: bufferOop) to: 'char *'..
	oggOop := interpreterProxy stackObjectValue: 2.
	oggp := self oggInstanceOf: oggOop.
	interpreterProxy success: (interpreterProxy isWordsOrBytes: bufferOop).
	interpreterProxy failed
		ifTrue: [^ nil].
	result := self cCode: 'SqOggWrite(oggp, buffer, size)'.
	interpreterProxy pop: 4.
	^ interpreterProxy pushInteger: result
	! !

!OggPlugin methodsFor: 'basic' stamp: 'tak 3/3/2007 14:59'!
primitiveWriteEOS: oggPtr 
	self primitive: 'primitiveWriteEOS' parameters: #(#ByteArray ).
	self cCode: 'SqOggWriteEOS((SqOggPtr *) oggPtr)'! !

!OggPlugin methodsFor: 'utilities' stamp: 'tak 3/3/2007 14:57'!
oggInstanceOf: oggOop 
	"Convert from Squeak pointer to SqOggPtr"
	| oggp |
	self returnTypeC: 'SqOggPtr *'.
	self var: #oggp declareC: 'SqOggPtr * oggp'.
	interpreterProxy
		success: ((interpreterProxy isBytes: oggOop)
				and: [(interpreterProxy byteSizeOf: oggOop)
						= (self cCode: 'sizeof(SqOggPtr)')]).
	oggp := self
				cCoerce: (interpreterProxy firstIndexableField: oggOop)
				to: 'SqOggPtr *'.
	^ oggp! !

!OggPlugin methodsFor: 'utilities' stamp: 'tak 12/17/2006 23:46'!
primitiveExtractMono
	| dest src destOop srcOop size channel |
	self export: true.
	self var: #dest declareC: 'short * dest'.
	self var: #src declareC: 'short * src'.
	self var: #buffer declareC: 'short * buffer'.
	interpreterProxy methodArgumentCount = 4
		ifFalse:[^interpreterProxy primitiveFail].
	destOop := interpreterProxy stackObjectValue: 3. "output buffer"
	srcOop := interpreterProxy stackObjectValue: 2. "source buffer"
	size := interpreterProxy stackIntegerValue: 1. "frame size (word size of dest)"
	channel := interpreterProxy stackIntegerValue: 0. "channel number"

	dest := self cCoerce: (interpreterProxy firstIndexableField: destOop) to: 'short *'.
	src := self cCoerce: (interpreterProxy firstIndexableField: srcOop) to: 'short *'.
	0 to: size - 1 do: [:i |
		dest at: i put: (src at: (i * 2 + channel))].
	^ interpreterProxy pop: 4.
	! !


!OggPlugin class methodsFor: 'utilities' stamp: 'tak 2/15/2007 21:22'!
buildSource: aString 
	"Before building the code, you need to place platforms/OggPlugin.h to Cross/plugins/OggPlugin/"
	"OggPlugin buildSource: '/home/takashi/src/squeak-svn/platforms'"
	"OggPlugin buildSource: 'c:\takashi\src\3.7.1'"
	| maker platformRootDirectoryName sourceDirectoryName |
	platformRootDirectoryName := aString.
	sourceDirectoryName := platformRootDirectoryName , FileDirectory slash , 'Cross'.
	SmalltalkImage current unloadModule: self name.
	maker := VMMaker default.
	maker platformRootDirectoryName: platformRootDirectoryName.
	maker sourceDirectoryName: sourceDirectoryName.
	maker logger: Transcript.
	maker makeAllModulesExternal.
	maker generateExternalPlugin: self name! !

!OggPlugin class methodsFor: 'plugin code generation' stamp: 'tak 12/12/2006 12:13'!
hasHeaderFile
	^ true! !

