/* (compile "make -k") */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include "OggPlugin.h"
#define BUFSIZE 4096

void basicTest()
{
  char buf1[]= {1, 2, 3};
  char buf2[]= {4, 5, 6};
  char buf3[]= {7, 8, 9};
  int size;
  char * flatten;
  int result;
  SqOggResult * next;

  SqOggResult * first= SqOggResultNewBuffer(NULL, 3);
  SqOggResult * second= SqOggResultNewBuffer(first, 3);
  SqOggResult * third= SqOggResultNewBuffer(first, 3);

  memcpy(first->buffer, buf1, sizeof(char) * 3);
  memcpy(second->buffer, buf2, sizeof(char) * 3);
  memcpy(third->buffer, buf3, sizeof(char) * 3);
  assert(first->buffer[2] == 3);
  assert(second->buffer[2] == 6);
  assert(third->buffer[2] == 9);
  assert(third->next == NULL);

  size= SqOggResultSize(first);
  assert(size == 9);

  flatten= malloc (sizeof(char) * size);
  result= SqOggResultCopy(first, flatten, size);
  assert(result == size);
  assert(flatten[0] == 1);
  assert(flatten[8] == 9);

  SqOggResultDestroy(first);

  /* malloc test */
  next= SqOggResultNewBuffer(NULL, 10000);
  SqOggResultDestroy(next);
}

void mallocTest()
{
  int j;
  SqOggResult * head;
  head= SqOggResultNewBuffer(NULL, 10000);
  for (j= 0; j < 9; j++) {
    SqOggResultNewBuffer(head, 10000);
  }
  SqOggResultDestroy(head);
}

int main()
{
  basicTest();
  mallocTest();
  return 0;
}
