/* A simple dump program for ogg */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "OggPlugin.h"
#define BUFSIZE 4096

void page_callback (ogg_page * page)
{
  printf("page_packets=%i\npage_granulepos=%lli\nogg_page_serialno=%i\nogg_page_pageno=%li\n",
         ogg_page_packets(page),
         ogg_page_granulepos(page),
         ogg_page_serialno(page),
         ogg_page_pageno(page));
}

int main(int argc, char * argv[])
{
  char write_buffer[BUFSIZE];
  SqOggPtr oggp;
  SqOgg * ogg;
  FILE * in;

  if (argc != 2) {
    fprintf(stderr, "usage: dump infile");
    exit(1);
  }
  in= fopen(argv[1], "rb");

  SqOggOpen(0, &oggp);
  ogg= oggp.ogg;
  ogg->page_callback= page_callback;

  while(1) {
    int bytes= fread(write_buffer, 1, BUFSIZE, in);
    SqOggWrite(&oggp, write_buffer, bytes);
    if (bytes == 0) return 0;

    while (1) {
      ogg_packet packet;
      int i;

      if (SqOggPacketNext(&oggp, &packet) == SQ_OGG_NEED_MORE) break;
      printf("\tbytes=%li granulepos=%lli packetno=%lli",
             packet.bytes,
             packet.granulepos,
             packet.packetno);
      if (packet.b_o_s) printf(" [b_o_s]");
      if (packet.e_o_s) printf(" [e_o_s]");
      printf("\n");

      for (i= 0; i < packet.bytes; i++) {
        if (isprint(packet.packet[i])) {
          //          printf("%c", packet.packet[i]);
        } else {
          //          printf(".");
        }
      }
      //      printf("\n");
    }
  }
  SqOggClose(&oggp);
  fclose(in);
  return 0;
}
