/* Ogg Pakcet write and read test */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include "OggPlugin.h"
#define BUFSIZE 4096
#define TRIAL 200
#define PACKET_SIZE_MAX 50
#define FILENAME "test.ogg"

unsigned int samples[TRIAL];

/* Genarate test data which includes random numbers from 2 to
 * PACKET_SIZE_MAX and the the sequence size is TRIAL. (why 2? for
 * placing < and > characters) */
void make_data()
{
  int i;
  srand(time(NULL));
  for (i= 0; i < TRIAL; i++) {
    samples[i]= (rand() * (PACKET_SIZE_MAX - 2) / RAND_MAX) + 2;
  }
}

void write_packet()
{
  unsigned char bits[PACKET_SIZE_MAX];
  FILE * out;
  int bytes;
  int i, n;
  char * buffer;
  SqOggPtr oggp;

  SqOggOpen(SQ_OGG_ENCODE, &oggp);

  for(i= 0; i < TRIAL; i++) {
    ogg_packet packet;
    packet.bytes= samples[i];
    
    for (n= 0; n < packet.bytes; n++) bits[n]= n % 10 + '0';
    bits[0]= '<';
    bits[packet.bytes - 1]= '>';

    packet.packet= bits;
    //    packet.e_o_s= 0; // e_o_s is needed to tell end of the packet.
    packet.e_o_s= (i == TRIAL - 1) ? 1 : 0;
    SqOggPacketWrite(&oggp, &packet);
    if (i % 10 == 0) SqOggPacketFlush(&oggp);
  }

  bytes= SqOggReadSize(&oggp);
  buffer= (char *) malloc(bytes);
  SqOggRead(&oggp, buffer, bytes);
  out= fopen(FILENAME, "wb");
  fwrite(buffer, 1, bytes, out);
  fclose(out);
  SqOggClose(&oggp);
}

void read_packet()
{
  char buffer[BUFSIZE];
  SqOggPtr oggp;
  FILE * in;
  ogg_packet packet;
  int i= 0;

  SqOggOpen(0, &oggp);
  in= fopen(FILENAME, "rb");

  while(1) {
    int bytes= fread(buffer, 1, BUFSIZE, in);
    SqOggWrite(&oggp, buffer, bytes);
    if (bytes == 0) break;

    while (1) {
      if (SqOggPacketNext(&oggp, &packet) == SQ_OGG_NEED_MORE) break;
      if (samples[i] != packet.bytes) {
        printf ("Packet mismatch i=%i\n", i);
        exit(1);
      }
      i++;
    }
  }
  if (i != TRIAL) {
    printf("Result size mismatch: trial=%i, result=%i", TRIAL, i);
    exit(1);
  }
  SqOggClose(&oggp);
  fclose(in);
}

int main(int argc, char * argv[])
{
  make_data();
  write_packet();
  read_packet();
  return 0;
}
