/* ogg speex decoder */

#include <stdio.h>
#include <stdlib.h>
#include <speex/speex_header.h>
#include "OggPlugin.h"
#define BUFSIZE 1024

int main(int argc, char * argv[])
{
  char read_buffer[BUFSIZE];
  SqOggPtr oggp;
  FILE * in;
  FILE * out;

  if (argc != 5) {
    fprintf(stderr, "usage: ./sencode rate channels infile outfile\n");
    exit(1);
  }
  
  in= fopen(argv[3], "rb");
  out= fopen(argv[4], "wb");

  SqOggOpen(SQ_SPEEX | SQ_OGG_ENCODE, &oggp);
  SqOggSetChannels(&oggp, atoi(argv[2]));
  SqOggSetRate(&oggp, atoi(argv[1]));
  SqOggSetQuality(&oggp, 8);

  while(1) {
    int bytes= fread(read_buffer, 1, BUFSIZE, in);
    if (bytes == 0) break;
    SqOggWrite(&oggp, read_buffer, bytes);
    SqOggResultWrite(&oggp, out);
  }
  SqOggPacketFlush(&oggp);
  SqOggWriteEOS(&oggp);
  SqOggResultWrite(&oggp, out);

  SqOggClose(&oggp);
  fclose(in);
  fclose(out);
  return 0;
}
