/* (compile "make -k") */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "OggPlugin.h"
#define BUFSIZE 4096

void showHeader(SqOggPtr * ogg)
{
  char vendor[BUFSIZE];
  int size;
  char * comment;
  int pos;
  fprintf(stderr,"Bitstream is %d channel, %dHz\n",
          SqOggGetChannels(ogg), SqOggGetRate(ogg));
  SqOggGetVendor(ogg, vendor, BUFSIZE);
  fprintf(stderr,"Encoded by: %s\n\n", vendor);

  size= SqOggGetCommentSize(ogg);
  comment= malloc(size);
  SqOggGetComment(ogg, comment, size);
  pos= 0;
  while(pos < size) {
    int eachSize= strlen(comment + pos);
    fprintf(stderr, "%s\n", comment + pos);
    pos= pos + eachSize + 1;
  }
}

int main(int argc, char * argv[])
{
  char write_buffer[BUFSIZE];

  SqOggPtr oggp;
  int isHeaderProcessed= 0;
  FILE * in;
  FILE * out;

  if (argc != 3) {
    fprintf(stderr, "usage: ./vencode infile outfile");
    exit(1);
  }
  in = fopen(argv[1], "rb");
  out = fopen(argv[2], "wb");

  SqOggOpen(SQ_VORBIS | SQ_OGG_DECODE, &oggp);

  while(1) {
    int result;
    int bytes= fread(write_buffer, 1, BUFSIZE, in);
    if (bytes == 0) return 0;

    result= SqOggWrite(&oggp, write_buffer, bytes);
    if (result != 0) {
      printf("error code=%i\n", result);
      return result;
    }
    if (!isHeaderProcessed && SqOggGetState(&oggp) == SQ_OGG_RUNNING) {
      showHeader(&oggp);
      isHeaderProcessed= 1;
    }
    SqOggResultWrite(&oggp, out);
  }
  SqOggClose(&oggp);
  fclose(out);
  fclose(in);
  return 0;
}
