/* Ogg Vorbis test program
 * 
 * encode rate channel infile outfile
 *
 * EXAMPLE: ./encode 44100 1 sample.raw sample.ogg
 */

#include <stdlib.h>
#include <string.h>
#include "OggPlugin.h"

#define BUFSIZE 4096

int main(int argc, char * argv[])
{
  char readbuffer[BUFSIZE];
  SqOggPtr oggp;
  FILE * in;
  FILE * out;

  if (argc != 5) {
    fprintf(stderr, "usage: ./vencode rate channels infile outfile");
    exit(1);
  }

  in = fopen(argv[3], "rb");
  out = fopen(argv[4], "wb");

  SqOggOpen(SQ_VORBIS | SQ_OGG_ENCODE, &oggp);
  SqOggSetChannels(&oggp, atoi(argv[2]));
  SqOggSetRate(&oggp, atoi(argv[1]));
  SqOggSetQuality(&oggp, 0.1);

  while(1){
    int size= fread(readbuffer, 1, BUFSIZE, in);
    if (size == 0) break;
    SqOggWrite(&oggp, readbuffer, size);
    SqOggResultWrite(&oggp, out);
  }
  SqOggWriteEOS(&oggp);
  SqOggResultWrite(&oggp, out);

  SqOggClose(&oggp);
  fclose(in);
  fclose(out);
  return 0;
}
